package gov.va.caret.controller.dashboard.config;

import java.util.Collection;
import java.util.Collections;

import javax.portlet.PortletRequest;

import com.liferay.portal.util.PortalUtil;
import com.liferay.util.portlet.PortletProps;

import gov.va.caret.ApplicationWorkFlowException;
import gov.va.caret.model.support.WorkType;
import gov.va.caret.security.CAction;
import gov.va.caret.security.CAction.CaretCan;
import gov.va.caret.service.CaretLocalServiceUtil;
import gov.va.caret.util.CaretStrPool;
import gov.va.caret.util.Toolbox;
import gov.va.caret.view.CachedReport;
import gov.va.caret.view.EnabledSearch;
import gov.va.caret.view.GenericReport;
import gov.va.caret.view.ReportParameter;
import gov.va.caret.view.ResultMap;

public class HealthDashboardConfig extends DashboardConfig {

	private static final long serialVersionUID = 1L;
	public final String VIEW = "/jsp/dashboard/health.jsp";
	
	public HealthDashboardConfig() {
		super();
		
		this.enabledSearch = new EnabledSearch( new CachedReport("referrals") );
		this.reports = new GenericReport[]{ 
				new GenericReport("overdueGroupReferrals", true, "c.creationDate", true, GenericReport.CALL_QUERY_NDX, ReportParameter.roleId ),
				new GenericReport("myNotes", true, "creationDate", true, GenericReport.NOTES_QUERY_NDX, ReportParameter.userId ),
				new GenericReport("groupReferrals", true, "c.creationDate", true, GenericReport.CALL_QUERY_NDX, ReportParameter.roleId ),
				new GenericReport("myReferrals", true, "c.creationDate", true, GenericReport.CALL_QUERY_NDX, ReportParameter.userId ) };
	}

	public final CAction.CaretCan[] getCreateActions(){
		return new CAction.CaretCan[]{
			CAction.CaretCan.CREATE_REFERRAL//,
			//CAction.CaretCan.CREATE_MESSAGES
		};
	}
	
	@Override
	public String getView() {
		return VIEW;
	}

	@Override
	public CaretCan[] getToolsActions() {
		return new CAction.CaretCan[]{
				CAction.CaretCan.STIPEND_CALCULATOR
			};
	}
	
	public void loadReports( PortletRequest request ) throws ApplicationWorkFlowException{
		super.loadReports( request );
		ResultMap.getCaretMap(request).put(CaretStrPool.USE_PHONE, true);
		ResultMap.getCaretMap(request).put( CaretStrPool.VHA_SYSTEM, Toolbox.getVhaOrgTree( PortalUtil.getCompanyId( request ), true ) );
		ResultMap.getCaretMap(request).put( "cgRoles", new String[]{"caller", "UNKNOWN_CALLER"} );
		request.setAttribute("roleUsers", CaretLocalServiceUtil.getReport( "cslUserList", Collections.singletonMap("roleGroup", "'" + getRole() + "'" )) );
		ResultMap.getCaretMap(request).put( "standard-call-types", Collections.singletonList("Referral") );
	}
	
	
	public Collection<String> workItemTypes() {
		String workType;
		try{
			workType = WorkType.valueOf( getRole() + "_REFERRAL").name();
		} catch ( Exception e ){
			workType = WorkType.REFERRAL.name();
		}
		
		return Collections.singletonList( workType );
	}
	
}

